$STACK 32766
REM                       SUPER STEPPER 1.0
REM                         10 AUG 1997
REM
CLS : WIDTH 40: COLOR 15, 0
LOCATE 3, 2: PRINT "       Stepster, Version .979"
LOCATE 5, 2: PRINT "Copyright 1997 by Haberle Machine Co."
LOCATE 7, 2: PRINT "      Written by Kevin Carroll"
rem DELAY 2

CLS
LOCATE 3, 2: PRINT "       This is a Beta Version"
LOCATE 5, 2: PRINT "        NOT FOR DISTRIBUTION"
rem DELAY 3



2 DIM t(10): DIM g(30): DIM misc(5, 2): hold = 0: CoSys = 1
  cycle = 0: jds = 1: hold = 0: plane = 1: firstmove = 0
  g90 = 1: g90.1 = 1: pi = 3.141592654#: pt = 127
5  CLS : lines = 0: CLOSE : OVR = 1: WIDTH 40

35 mX = 10: mY = 10: mZ = 1:
   KEY 19, CHR$(0) + CHR$(74): KEY 20, CHR$(0) + CHR$(78): '+   -
   KEY 21, CHR$(0) + CHR$(20): KEY 22, CHR$(0) + CHR$(45): 'T - X
   KEY 23, CHR$(0) + CHR$(21): KEY 24, CHR$(0) + CHR$(44): 'Y - Z
   ON KEY(21) GOSUB 700: ON KEY(22) GOSUB 710: ON KEY(23) GOSUB 720: 'T X Y
   ON KEY(24) GOSUB 730: ON KEY(12) GOSUB 740: ON KEY(13) GOSUB 750: 'Z L-R
   ON KEY(11) GOSUB 760: ON KEY(14) GOSUB 770: ON KEY(19) GOSUB 780: 'U-D +
   ON KEY(20) GOSUB 790: '-

100 OPEN "exec.dat" FOR INPUT AS #2
    LINE INPUT #2, port$: port = VAL(port$): ' lpt port
    LINE INPUT #2, port2off$: port2off = VAL(port2off$): ' offset for input
    LINE INPUT #2, mX$: mX1 = VAL(mX$): ' motor step X
    LINE INPUT #2, mY$: mY1 = VAL(mY$): ' motor step Y
    LINE INPUT #2, mZ$: mZ1 = VAL(mZ$): ' motor step Z
    LINE INPUT #2, Xb$: Xb = VAL(Xb$): ' X backlash
    LINE INPUT #2, Yb$: Yb = VAL(Yb$): ' Y backlash
    LINE INPUT #2, Zb$: Zb = VAL(Zb$): ' Z backlash
    LINE INPUT #2, panel$: panel = VAL(panel$): ' contol panel present =1
    LINE INPUT #2, IJ$: IJ = VAL(IJ$): ' I&J incremental = 1
    LINE INPUT #2, pX$: pX = VAL(pX$): ' pin for X pos
    LINE INPUT #2, nX$: nX = VAL(nX$): ' pin for X neg
    LINE INPUT #2, pY$: pY = VAL(pY$): ' Y+
    LINE INPUT #2, nY$: nY = VAL(nY$): ' Y-
    LINE INPUT #2, pZ$: pZ = VAL(pZ$): ' Z+
    LINE INPUT #2, nZ$: nZ = VAL(nZ$): ' Z-
    LINE INPUT #2, rA$: rA = VAL(rA$): ' pin for relay A
    LINE INPUT #2, rB$: rB = VAL(rB$): ' relay B
    LINE INPUT #2, rapid$: rapid = VAL(rapid$): 'IPM G0
    CLOSE #2
    OUT port, 255 AND NOT rA + rB: ' turn relays off
    port1 = port + 1: port2 = port + 2
    OUT port1, 255: OUT port2, 4: 'prepare panel
    port2 = port2 + port2off: ' some lpt ports input 1 byte higher

    OPEN "speed.dat" FOR INPUT AS #2
    LINE INPUT #2, compspeed$: compspeed = VAL(compspeed$): '
    LINE INPUT #2, accf$: accf = VAL(accf$): 'accel / decel factor
    LINE INPUT #2, accd$: accd = VAL(accd$): ' accel / decel distance
    LINE INPUT #2, rapid$: rpd = VAL(rapid$): ' limit rapid traverse
    LINE INPUT #2, backX$: backX = VAL(backX$): ' back up after homing X
    LINE INPUT #2, backY$: backY = VAL(backY$)
    LINE INPUT #2, backZ$: backZ = VAL(backZ$)
    CLOSE #2
    FRF = compspeed / 100
    rapid = rapid - 2
    mX = mX1: mY = mY1: mZ = mZ1
    g(16) = 1: g(17) = 1: g(18) = 1
    IF IJ = 1 THEN g90.1 = 0 ELSE g90.1 = 1
    

110 OPEN "color.dat" FOR INPUT AS #3
    LINE INPUT #3, bground$: bground = VAL(bground$): '
    LINE INPUT #3, axis$: axis = VAL(axis$): 'axis display
    LINE INPUT #3, action$: action = VAL(action$): ' feed, overide, run, block
    LINE INPUT #3, gee$: gee = VAL(gee$): ' active G codes
    LINE INPUT #3, en$: en = VAL(en$): ' current line (N)
    LINE INPUT #3, prompt$: prompt = VAL(prompt$): ' screen prompts
    CLOSE #3

130 CLS : COLOR axis, bground
   FOR p = 1 TO 25
   PRINT "                                        "
   NEXT p


   LOCATE 2, 14: PRINT "X":  LOCATE 4, 14: PRINT "Y":  LOCATE 6, 14: PRINT "Z"
   COLOR action
   LOCATE 8, 2: PRINT "F": LOCATE 8, 4: PRINT "100  ": LOCATE 10, 2: PRINT "%"
   LOCATE 10, 4: PRINT "100": COLOR axis: LOCATE 6, 28: PRINT "T  0 "
   COLOR gee
   LOCATE 2, 1: PRINT "G"; 50: rot = 0:


150 CLOSE : REM                                        MENU
    can = 0: H2 = 0: homing = 0: HomeX = 0: HomeY = 0: HomeZ = 0
    KEY(1) OFF: KEY(2) OFF
    COLOR axis, bground
    LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
    LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
    LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
    LOCATE 6, 28: PRINT "T"; tn
    COLOR gee
    LOCATE 4, 1: PRINT "G"; CoSys + 52

    LOCATE 6, 1: PRINT "G";
    LOCATE 6, 2: IF g90 = 1 THEN PRINT 90; "  "
    LOCATE 6, 2: IF g90.1 = 1 THEN PRINT "90.1"
    LOCATE 6, 2: IF g90 = 0 THEN PRINT 90
    plane = 1: LOCATE 2, 36: PRINT "G 17"
    goX = 0: goY = 0: goZ = 0:
    X$ = "                                        "
    FOR R = 8 TO 23: LOCATE R, 1: PRINT X$; : NEXT R
    OUT port, 255 AND NOT rA + rB: ' turn off relays
    POKE &H417, PEEK(&H417 OR &H40): ' kill caps lock
    POKE &H417, PEEK(&H417 OR &H20): '  kill num lock
    COLOR prompt
    LOCATE 21, 1: PRINT "     F1         F2       F3     F9      "
    LOCATE 22, 1: PRINT "    AUTO      MANUAL     MDI    DOS     "
    COLOR action
    LOCATE 20, 1: PRINT "               BETA VERSION            "

260 ON KEY(1) GOSUB 400: ON KEY(2) GOSUB 405
    ON KEY(3) GOSUB 410: ON KEY(9) GOSUB 415
    KEY(1) ON: KEY(2) ON: KEY(3) ON: KEY(9) ON

    KEY(7) OFF: KEY(8) OFF: KEY(15) OFF: KEY(16) OFF:
    KEY(17) OFF: KEY(18) OFF: KEY(19) OFF: KEY(20) OFF:
    KEY(21) OFF: KEY(22) OFF: KEY(23) OFF: KEY(24) OFF

270 IF panel = 0 THEN GOTO 260
    GOSUB 20000: 'read panel
    IF rot = 0 THEN GOTO 400
    IF rot = 7 THEN GOTO 410
    IF rot <> 0 AND rot <> 7 THEN GOTO 500
395 GOTO 270

400 KEY(9) OFF: MDI = 0: goX = 0: goY = 0: goZ = 0: hey = hey + 1: GOTO 2000: 'auto
405 KEY(9) OFF: MDI = 0: GOTO 500: ' manual
410 KEY(9) OFF: MDI = 1: block = 0: GOTO 1000
415 CLS : PRINT FRE(""); FRE(-1); FRE(-2): SYSTEM

500 REM                                                   manual mode
    g90 = 1: g(2) = 1: g(9) = 100
    COLOR action: LOCATE 8, 28: PRINT "JOG"
    COLOR prompt
    LOCATE 14, 1: PRINT "   Press   'X'   'Y'   'Z'   to zero"
    LOCATE 15, 1: PRINT "                                    "
    LOCATE 17, 2: PRINT CHR$(27); " "; CHR$(26); "   "; CHR$(24); " ";
    PRINT CHR$(25); "   - +     T      F7    F8"
    LOCATE 18, 1: PRINT "  X     Y     Z    TOOL#   JOG#  MENU"
    LOCATE 21, 1: PRINT " F1   F2     F3     F4       F5      F6 "
    LOCATE 22, 1: PRINT "HOLD  -OVERIDE+  GOTO XY0  GOTO T0  STOP"
    ON KEY(2) GOSUB 7982: ON KEY(3) GOSUB 7984: KEY(2) ON: KEY(3) ON: 'overide
    KEY(4) OFF: ON KEY(4) GOSUB 810: KEY(5) OFF: ON KEY(5) GOSUB 820
580 ON KEY(6) GOSUB 7900: ON KEY(7) GOSUB 800: ON KEY(8) GOSUB 850
585 KEY(7) ON: KEY(8) ON: KEY(11) ON: KEY(12) ON: KEY(13) ON: KEY(14) ON
    KEY(19) ON: KEY(20) ON: KEY(21) ON: KEY(22) ON: KEY(23) ON: KEY(24) ON
    KEY(4) ON: KEY(5) ON: KEY(6) ON
    IF panel = 0 THEN GOTO 600
    GOSUB 20000: 'read panel
    IF rot = 0 THEN GOTO 400
    IF rot = 7 THEN GOTO 410
    IF rot <> 0 AND rot <> 7 THEN GOTO 500

600 KEY(2) STOP: KEY(3) STOP: KEY(4) STOP: KEY(5) STOP: KEY(6) STOP
    COLOR axis
    LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
    LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
    LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
    LOCATE 6, 28: PRINT "T"; tn
    COLOR action
    LOCATE 8, 2: PRINT "F RAPID"
    LOCATE 10, 2: PRINT "% "; : PRINT USING "###"; OVR * 100
    LOCATE 10, 28: PRINT USING "#.####"; jd / 10000; : PRINT "    "
    KEY(2) ON: KEY(3) ON: KEY(4) ON: KEY(5) ON: KEY(8) ON
    IF panel = 1 THEN GOSUB 900
    IF gojog = 0 THEN GOTO 585
    KEY(7) OFF: KEY(8) OFF: KEY(11) OFF: KEY(12) OFF: KEY(13) OFF: KEY(14) OFF
    KEY(19) OFF: KEY(20) OFF: KEY(21) OFF: KEY(22) OFF: KEY(23) OFF

690 cycle = 1: hold = 0: mode = 1: GOSUB 6700: 'backlash setup then move loop
    goX = 0: goY = 0: goZ = 0: gojog = 0: cycle = 0: GOTO 585

700 tn = tn + 1: IF tn > 10 THEN tn = 0: '                      cycle Tool
705 IF CoSys = 1 THEN bZ = cZ - t(tn)
    IF CoSys = 2 THEN bZ = cZ + Z54off - t(tn)
    IF CoSys = 3 THEN bZ = cZ + Z55off - t(tn)
    RETURN

710  IF CoSys = 1 THEN cX = 0
     bX = 0: RETURN: '                                             zero X

720  IF CoSys = 1 THEN cX = 0
     bY = 0: RETURN: '                                               zero Y

730  IF tn = 0 THEN cZ = 0: GOTO 705: '                              zero Z
     t(tn) = cZ: GOTO 705: '                                        zero tool
740  IF mX >= jd THEN jd = mX ELSE jd = jds
goX = jd * -1: gojog = 1: RETURN: '                                     X-
750 IF mX >= jd THEN jd = mX ELSE jd = jds
goX = jd: gojog = 1: RETURN: '                                           X+
760  IF mY >= jd THEN jd = mY ELSE jd = jds
goY = jd: gojog = 1: RETURN: '                                           Y+
770  IF mY >= jd THEN jd = mY ELSE jd = jds
goY = jd * -1: gojog = 1: RETURN: '                                      Y-
780  IF mZ >= jd THEN jd = mZ ELSE jd = jds
goZ = jd * -1: gojog = 1: RETURN: '                                      Z+
790  IF mZ >= jd THEN jd = mZ:  ELSE jd = jds
goZ = jd: gojog = 1: RETURN: '                                           Z-
800 jds = jds / 10: IF jds < 1 THEN jds = 10000: '                 cycle jog#
805 jd = jds: RETURN
810 KEY(4) OFF
812 goX = bX * -1: goY = bY * -1: gojog = 1: '   goto XY zero
815 KEY(4) OFF: RETURN
820 tn = 0: goZ = cZ * -1: gojog = 1:  ' call T0, goto Z zero
825 KEY(5) OFF: RETURN
850 GOTO 150: '                                                go to menu
895 GOTO 580

900 REM        manual panel "gosub 20000" reads switches at LPT port
    GOSUB 20000

    IF rot = 6 THEN
    IF button = butpress THEN FOR slow = 1 TO 10000: NEXT slow
    IF button = 1 THEN GOSUB 7982
    IF button = 2 THEN GOSUB 7984
    butpress = button
    END IF
910 IF rot = 5 THEN
    IF butpress = button THEN 915
    IF button = 1 THEN tn = tn - 1: IF tn < 0 THEN tn = 0
    IF button = 2 THEN tn = tn + 1: IF tn > 10 THEN tn = 10
    bZ = cZ - t(tn)
    IF button = 3 THEN t(tn) = cZ: bZ = cZ - t(tn)
    butpress = button
    END IF
915 IF rot = 1 THEN
    IF butpress = button THEN 920
    IF button = 1 THEN jd = jd / 10: IF jd < 1 THEN jd = 1
    IF button = 2 THEN jd = jd * 10: IF jd > 10000 THEN jd = 10000
    butpress = button
    END IF
920 IF rot = 2 THEN
    IF button = 1 THEN goX = mX * jd * -1: gojog = 1
    IF button = 2 THEN goX = mX * jd: gojog = 1
    IF button = 3 THEN bX = 0
    END IF
925 IF rot = 3 THEN
    IF button = 1 THEN goY = mY * jd * -1: gojog = 1
    IF button = 2 THEN goY = mY * jd: gojog = 1
    IF button = 3 THEN bY = 0
    END IF
930 IF rot = 4 THEN
    IF button = 1 THEN goZ = mZ * jd * -1: gojog = 1
    IF button = 2 THEN goZ = mZ * jd: gojog = 1
    IF button = 3 THEN t(tn) = cZ: bZ = cZ - t(tn)
    END IF
935 IF rot = 7 OR rot = 0 THEN 150
940 RETURN

1000 REM                                                      MDI Mode
     KEY(2) STOP: KEY(3) STOP: KEY(4) STOP: g90 = 1
     ON KEY(2) GOSUB 7984: ON KEY(3) GOSUB 7982: KEY(2) ON: KEY(3) ON
     COLOR axis
     LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
     LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
     LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
     LOCATE 6, 30: PRINT tn
     LOCATE 10, 28:
     LOCATE 2, 14: PRINT "X":  LOCATE 4, 14: PRINT "Y":  LOCATE 6, 14: PRINT "Z"
     COLOR action
     LOCATE 8, 2: PRINT "F"
     LOCATE 10, 2: PRINT "%"; : PRINT "                                    "
     COLOR prompt
     LOCATE 21, 1: PRINT " F1     F2     F3     F4     F5      F6 "
     LOCATE 22, 1: PRINT "HOLD    -OVERIDE+   BLOCK   START   STOP"

1500 LOCATE 16, 1: PRINT "                                        "
     COLOR en
     LOCATE 16, 1: INPUT l$
     goX = 0: goY = 0: goZ = 0
     IF l$ = "" THEN MDI = 0: GOTO 150
     COLOR action
     IF block = 1 THEN COLOR action: LOCATE 10, 28: PRINT "BLOCK MODE": GOTO 1900
     COLOR action: LOCATE 10, 28: PRINT "NORMAL MODE"
1900 cycle = 1: GOSUB 3000
     GOTO 1500
     STOP

2000 REM FILE TRANSFER SECTION

2010 ON ERROR GOTO 2020
     OPEN "last.dat" FOR INPUT AS #4
     LINE INPUT #4, oldfile$
     CLOSE #4
     GOTO 2021

2020 RESUME 2021
2021 REM

2050 CLOSE : ON ERROR GOTO 2070: REM TRAP FILE NAME ERRORS
2060 GOTO 2100
2070 PRINT : PRINT " FILE NOT FOUND": PRINT : GOTO 5

2100 REM
     LOCATE 21, 1: PRINT "                                        "
     LOCATE 22, 1: PRINT "                                        "
     file$ = ""
     COLOR prompt
     LOCATE 21, 1: PRINT "    File to run? "; oldfile$
2150 f$ = INKEY$
     IF f$ = "" THEN 2150
    
     IF (f$) = CHR$(13) THEN 2160
     file$ = file$ + f$
     LOCATE 21, 18: PRINT "                      "
     LOCATE 21, 18: PRINT file$
     GOTO 2150
2160 '
     IF file$ = "" THEN file$ = oldfile$
     ON ERROR GOTO 2210
     CLOSE : OPEN file$ FOR INPUT AS #1: lines = 0
     ON ERROR GOTO 2200
     OPEN "last.dat" FOR OUTPUT AS #4
     PRINT #4, file$
     CLOSE #4


2180 INPUT #1, lines$
     lines = lines + 1: LOCATE 19, 12: PRINT lines
     GOTO 2180

2200 CLOSE #1: RESUME 2220
2210 CLOSE #1: RESUME 2100
2220 ON ERROR GOTO 150

2310 CLOSE #1
     ON KEY(2) GOSUB 7984: ON KEY(3) GOSUB 7982: KEY(2) ON: KEY(3) ON
2320 OPEN file$ FOR INPUT AS #1
     REM CLS : WIDTH 40
     COLOR axis
     LOCATE 2, 14: PRINT "X":  LOCATE 4, 14: PRINT "Y":  LOCATE 6, 14: PRINT "Z"
     COLOR action
     LOCATE 8, 2: PRINT "F"
     LOCATE 10, 2: PRINT "%": '                                   "
     COLOR prompt
     LOCATE 21, 1: PRINT " F1     F2     F3     F4     F5      F6 "
     LOCATE 22, 1: PRINT "HOLD    -OVERIDE+   BLOCK   START   STOP"

2500 ON KEY(4) GOSUB 2505: KEY(4) ON: GOTO 2520
2505 IF block = 0 THEN block = 1 ELSE block = 0
     COLOR action
     IF block = 1 THEN COLOR action: LOCATE 10, 28: PRINT "BLOCK MODE ": RETURN
     COLOR action: LOCATE 10, 28: PRINT "NORMAL MODE": RETURN
2520 IF block = 1 THEN COLOR action: LOCATE 10, 28: PRINT "BLOCK MODE": GOTO 2530
     COLOR action: LOCATE 10, 28: PRINT "NORMAL MODE"
2530 REM
     ON KEY(5) GOSUB 2545: GOTO 2550
2545 cycle = 1: RETURN
2550 ON KEY(6) GOSUB 2555: GOTO 2560
2555 cycle = 0: RETURN
2560 REM
2599 REM

2900 FOR linecount = 1 TO lines
     goX = 0: goY = 0: goZ = 0: goI = 0: goJ = 0: goK = 0

2990 LINE INPUT #1, l$
     COLOR prompt
     LOCATE 19, 2: PRINT "Block       "
     LOCATE 19, 7: PRINT USING "######"; linecount
     LOCATE 19, 14: PRINT "OF        "
     LOCATE 19, 16: PRINT USING "######"; lines

3000 FOR letter = 1 TO LEN(l$)

     Q$ = MID$(l$, letter, 1)
     IF Q$ = "(" THEN
	COLOR en
	LOCATE 17, 1: PRINT "                                         "
	LOCATE 18, 1: PRINT "                                        "
	LOCATE 17, 1: PRINT "("; RIGHT$(l$, LEN(l$) - letter): GOTO 3500
     END IF
     IF Q$ = " " THEN GOTO 3400
     IF Q$ = "N" THEN place = 1: GOTO 5000
     IF Q$ = "G" THEN place = 2: GOTO 5000
     IF Q$ = "X" THEN place = 3: GOTO 5000
     IF Q$ = "Y" THEN place = 4: GOTO 5000
     IF Q$ = "Z" THEN place = 5: GOTO 5000
     IF Q$ = "I" THEN place = 6: GOTO 5000
     IF Q$ = "J" THEN place = 7: GOTO 5000
     IF Q$ = "K" THEN place = 8: GOTO 5000
     IF Q$ = "F" THEN place = 9: GOTO 5000
     IF Q$ = "M" THEN place = 10: GOTO 5000
     IF Q$ = "S" THEN place = 11: GOTO 5000
     IF Q$ = "T" THEN place = 12: GOTO 5000
     IF Q$ = "L" THEN place = 14: GOTO 5000
     IF Q$ = "P" THEN place = 15: GOTO 5000
     IF Q$ = "U" THEN place = 16: GOTO 5000
     IF Q$ = "V" THEN place = 17: GOTO 5000
     IF Q$ = "W" THEN place = 18: GOTO 5000
     IF Q$ = "R" THEN place = 19: GOTO 5000

     IF Q$ = "n" THEN place = 1: GOTO 5000
     IF Q$ = "g" THEN place = 2: GOTO 5000
     IF Q$ = "x" THEN place = 3: GOTO 5000
     IF Q$ = "y" THEN place = 4: GOTO 5000
     IF Q$ = "z" THEN place = 5: GOTO 5000
     IF Q$ = "i" THEN place = 6: GOTO 5000
     IF Q$ = "j" THEN place = 7: GOTO 5000
     IF Q$ = "k" THEN place = 8: GOTO 5000
     IF Q$ = "f" THEN place = 9: GOTO 5000
     IF Q$ = "m" THEN place = 10: GOTO 5000
     IF Q$ = "s" THEN place = 11: GOTO 5000
     IF Q$ = "t" THEN place = 12: GOTO 5000
     IF Q$ = "\" THEN place = 13: GOTO 5030
     IF Q$ = "l" THEN place = 14: GOTO 5000
     IF Q$ = "p" THEN place = 15: GOTO 5000
     IF Q$ = "u" THEN place = 16: GOTO 5000
     IF Q$ = "v" THEN place = 17: GOTO 5000
     IF Q$ = "w" THEN place = 18: GOTO 5000
     IF Q$ = "r" THEN place = 19: GOTO 5000


3400 NEXT letter

3500 REM                                                  POST PARSER GUIDE
'epa = end point angle, cpa = center point angle
     IF rot = 1 AND mode < 5 THEN
       '                                          rotation G53
       '                    convert to polar coords, add angle, convert back

     X = g(3): Y = g(4):
     I = g(6): J = g(7):
     U = g(16): V = g(17): R = g(19)

     IF g90 = 0 THEN X = bX + g(3): Y = bY + g(4)
     IF g90.1 = 0 THEN I = oldX + g(6): J = oldY + g(7)

     exx = ABS(X - U): wye = ABS(Y - V): eye = ABS(I - U): jay = ABS(J - V)
     IF exx = 0 THEN epa = pi / 2
     IF wye = 0 THEN epa = 0
     IF exx <> 0 AND wye <> 0 THEN epa = ATN(wye / exx)

     IF eye = 0 THEN cpa = pi / 2
     IF jay = 0 THEN cpa = 0
     IF eye <> 0 AND jay <> 0 THEN cpa = ATN(jay / eye)

'should the following sections be" pi /2 + epa", etc.? NO, WORKS OK
     IF X < U AND Y > V THEN epa = pi - epa
     IF X <= U AND Y <= V THEN epa = pi + epa
     IF X > U AND Y <= V THEN epa = 2 * pi - epa

     IF I <= U AND J > V THEN cpa = pi - cpa
     IF I <= U AND J <= V THEN cpa = pi + cpa
     IF I > U AND J <= V THEN cpa = 2 * pi - cpa

     epr = SQR(exx * exx + wye * wye): 'end point radius
     cpr = SQR(eye * eye + jay * jay): ' center point radius

     epa = epa + (R * pi / 180):'  radians/degrees
     cpa = cpa + (R * pi / 180)

     Xa = epr * COS(epa)
     Ya = epr * SIN(epa)
     Ia = cpr * COS(cpa)
     Ja = cpr * SIN(cpa)

     goX = Xa * 10000 - bX
     goY = Ya * 10000 - bY
     goI = Ia * 10000 - bX
     goJ = Ja * 10000 - bY

 'I & J need to be based off of old X and Y
     oldX = X: oldY = Y
     END IF

     KEY(6) STOP: ON KEY(6) GOSUB 7900: '                      POST PARSER
     COLOR action
     IF hold = 0 AND cycle = 1 THEN LOCATE 8, 28: PRINT "RUN    "
     IF cycle = 0 THEN LOCATE 8, 28: PRINT "STOP   "
     IF block = 0 THEN 3505
     cycle = 0
3505 LOCATE 14, 1: PRINT "                                                "
     LOCATE 15, 1: PRINT "                                               "
     COLOR axis
     LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
     LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
     LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
     LOCATE 6, 30: PRINT tn
     COLOR en
     LOCATE 14, 1: PRINT l$
     COLOR action
     LOCATE 10, 4: PRINT USING "###"; OVR * 100; : PRINT "   "
     KEY(5) ON: KEY(6) ON
     IF hold = 0 AND cycle = 1 THEN LOCATE 8, 28: PRINT "RUN    "
     IF cycle = 0 THEN LOCATE 8, 28: PRINT "STOP   "
3540 IF cycle = 0 THEN 3540

3545 ON mode GOSUB 6700, 6700, 8000, 8000, 3625, 3650, 3600, 3700, 3550, 3750
     REM          rapid  line   G2    G3   dwell  g92  readT loadT null,scaling
     REM            1      2     3    4     5      6     7     8    9    10

     IF HomeX = 1 THEN
	HomeX = 0: H2 = 1 '                            2nd Homing Move.
	mode = 1
	goX = backX
	GOSUB 6700
	H2 = 0
	cX = 0: bX = 0
	mode = 9
	GOTO 3505
     END IF
     IF HomeY = 1 THEN
	HomeY = 0: H2 = 1: '                          Home Y
	mode = 1
	goY = backY
	GOSUB 6700
	H2 = 0
	cY = 0: bY = 0
	mode = 9
	GOTO 3505
     END IF
     IF HomeZ = 1 THEN
	HomeZ = 0: H2 = 1: '                           Home Z
	mode = 1
	goZ = backZ
	GOSUB 6700
	H2 = 0
	cZ = 0: bZ = 0
	mode = 9
	GOTO 3505
     END IF
     '                                             G81 drill cycle
     IF can = 1 THEN
	IF g90 = 1 THEN goZ = g(5) * 10000 - bZ
	IF g90 = 0 THEN goZ = g(5) * 10000
	mode = 2: goX = 0: goY = 0
	GOSUB 6700
	IF g90 = 1 THEN goZ = g(19) * 10000 - bZ
	IF g90 = 0 THEN goZ = g(19) * 10000
	mode = 1: goX = 0: goY = 0
	GOSUB 6700
     END IF
     tread = 0

3550 IF MDI = 1 THEN cycle = 0: GOTO 1500
     NEXT linecount
     LOCATE 14, 1: PRINT "                                                   "
     cycle = 0: GOTO 150: ' 2310: '150      'end post parser


3600 REM                                              Tool Data Read MODE 7

     tn = g(12): t(tn) = g(14) * 10000: mode = 9: RETURN

3625 IF cycle = 0 THEN 3625: REM                     Dwell           MODE 4
    DELAY g(15):
     RETURN

3650 IF CoSys = 2 THEN 3675: REM                      G92   G53      MODE 6
     IF CoSys = 3 THEN 3685
     CoSys = 1
     cX = g(3) * 10000: cY = g(4) * 10000: cZ = g(5) * 10000
     t(0) = cZ
     bX = cX: bY = cY: bZ = cZ
     COLOR axis
     LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
     LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
     LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
     LOCATE 6, 28: PRINT "T"; tn
     mode = 8
     COLOR gee
     LOCATE 4, 1: PRINT "G"; CoSys + 52
     RETURN
     STOP

3675 REM                                                        G92 G54
     bX = g(3) * 10000: bY = g(4) * 10000: bZ = g(5) * 10000
     X54off = cX - bX: Y54off = cY - bY: Z54off = cZ - bZ
     COLOR axis
     LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
     LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
     LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
     LOCATE 6, 28: PRINT "T"; tn
     COLOR gee
     LOCATE 4, 1: PRINT "G"; CoSys + 52
     mode = 9: RETURN

3685 REM                                                        G92 G55
     bX = g(3) * 10000: bY = g(4) * 10000: bZ = g(5) * 10000
     X55off = cX - bX: Y55off = cY - bY: Z55off = cZ - bZ
     COLOR axis
     LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
     LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
     LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
     LOCATE 6, 28: PRINT "T"; tn
     COLOR gee
     LOCATE 4, 1: PRINT "G"; CoSys + 52
     mode = 9:
     RETURN


3700 REM                                        Tool Data Load     MODE 8
3705 IF CoSys = 1 THEN bZ = cZ - t(tn1)
     IF CoSys = 2 THEN bZ = cZ + Z54off - t(tn1)
     IF CoSys = 3 THEN bZ = cZ + Z55off - t(tn1)
     COLOR axis
     LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
     mode = 9
     RETURN

3750 REM                                              Scaling    MODE 10
     COLOR gee
     LOCATE 2, 1: PRINT "G"; g(2)
     IF g(2) = 51 THEN
	 IF g(16) = 0 THEN g(16) = 1: 'U
	 IF g(17) = 0 THEN g(17) = 1: 'V
	 IF g(18) = 0 THEN g(18) = 1: 'W
	 g(16) = ABS(g(16)): g(17) = ABS(g(17)): g(18) = ABS(g(18))
	 mX = mX1 / g(16): mY = mY1 / g(17): mZ = mZ1 / g(18)
	 COLOR gee
	 LOCATE 2, 7: PRINT "     "
	 LOCATE 2, 7: PRINT USING "###"; g(16) * 100; : PRINT "%"
	 LOCATE 4, 7: PRINT "     "
	 LOCATE 4, 7: PRINT USING "###"; g(17) * 100; : PRINT "%"
	 LOCATE 6, 7: PRINT "     "
	 LOCATE 6, 7: PRINT USING "###"; g(18) * 100; : PRINT "%"
	 RETURN
     END IF
3760 REM                                                      Unscaling
     IF g(2) = 50 THEN
	 rot = 0
	 mX = mX1: mY = mY1: mZ = mZ1: g(16) = 1: g(17) = 1: g(18) = 1
	 LOCATE 2, 7: PRINT "     "
	 LOCATE 4, 7: PRINT "     "
	 LOCATE 6, 7: PRINT "     "
	 LOCATE 4, 35: PRINT "     "
	 RETURN
     END IF

3770 IF g(2) = 52 THEN
	 rot = 1
	 COLOR gee
	 LOCATE 4, 35: PRINT "R "; : PRINT USING "###"; g(19)
	 RETURN
	 END IF

5000 REM                                                  PARSER
     IF MID$(l$, letter + 1, 2) = "- " THEN MID$(l$, letter + 1, 2) = " -"
     g(place) = VAL(MID$(l$, letter + 1, 10))
     letter = letter + 1

5030 ON place GOTO 5100, 5200, 5300, 5400, 5500, 5600, 5700, 5800, 5900, 6000, 6100, 6200, 6300, 6400, 6425, 6450, 6475, 6500, 6550
     STOP: '        N     G     X     Y     Z     I     J     K     F     M     S     T      \     L    P     U     V     W     R
     REM    g(      1     2     3     4     5     6     7     8     9     10    11    12    13    14   15    16     17    18    19

5100 REM                                                PARSE  N
     GOTO 3400: 'next letter

5200 REM                                                PARSE  G
'trap g92, g90, g91 ,g04
     IF g(2) = 0 THEN mode = 1: can = 0: GOTO 3400
     IF g(2) = 1 THEN mode = 2: can = 0: GOTO 3400
     IF g(2) = 2 THEN mode = 3: can = 0: GOTO 3400
     IF g(2) = 3 THEN mode = 4: can = 0: GOTO 3400
     IF g(2) = 4 THEN mode = 5: GOTO 3400
     IF g(2) = 17 THEN
	 COLOR gee
	 plane = 1: LOCATE 2, 36: PRINT "G 17"
	 GOTO 3400
	 END IF
     IF g(2) = 18 THEN
	 COLOR gee
	 plane = 2: LOCATE 2, 36: PRINT "G 18"
	 GOTO 3400
	 END IF
     IF g(2) = 19 THEN
	 COLOR gee
	 plane = 3: LOCATE 2, 36: PRINT "G 19"
	 GOTO 3400
	 END IF
     IF g(2) = 50 THEN mode = 10: GOTO 3400
     IF g(2) = 51 THEN mode = 10: GOTO 3400
     IF g(2) = 52 THEN mode = 10: GOTO 3400

     IF g(2) <> 53 THEN 5250: '                                  G53
	 REM IF CoSys = 1 THEN 5250
	 CoSys = 1: bX = cX: bY = cY: bZ = cZ - t(tn)
	 COLOR axis
	 LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
	 LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
	 LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
	 LOCATE 6, 28: PRINT "T"; tn
	 COLOR gee
	 LOCATE 4, 1: PRINT "G"; CoSys + 52
	 mode = 9: ' null mode
	 GOTO 3400

5250 IF g(2) <> 54 THEN 5260: '                                  G54
	 REM IF CoSys = 2 THEN 5260
	 CoSys = 2: bX = cX - X54off: bY = cY - Y54off:
	 bZ = cZ - Z54off - t(tn)
	 COLOR axis
	 LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
	 LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
	 LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
	 LOCATE 6, 28: PRINT "T"; tn
	 mode = 9:
	 COLOR gee
	 LOCATE 4, 1: PRINT "G"; CoSys + 52
	 GOTO 3400

5260 IF g(2) <> 55 THEN 5270: '                                   G55
	 REM IF CoSys = 3 THEN 5270
	 CoSys = 3: bX = cX - X55off: bY = cY - Y55off:
	 bZ = cZ - Z55off - t(tn)
	 COLOR axis
	 LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
	 LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
	 LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
	 LOCATE 6, 28: PRINT "T"; tn
	 mode = 9
	 COLOR gee
	 LOCATE 4, 1: PRINT "G"; CoSys + 52
	 GOTO 3400
5270 REM                                                      Parse G
     IF g(2) = 81 THEN can = 1: mode = 1: GOTO 3400
     IF g(2) = 90 THEN
	  g90 = 1: g90.1 = 0: mode = 9:
	  COLOR gee
	  LOCATE 6, 1: PRINT "G 90  ": GOTO 3400
	  END IF
     IF g(2) = 91 THEN
	  g90 = 0: g90.1 = 0: mode = 9:
	  COLOR gee
	  LOCATE 6, 1: PRINT "G 91  ": GOTO 3400
	  END IF
     IF g(2) = 90.1 THEN
	  g90.1 = 1: g90 = 1: mode = 9
	  COLOR gee
	  LOCATE 6, 1: PRINT "G90.1": GOTO 3400
	  END IF
     IF g(2) = 92 THEN mode = 6
     REM  \ = tlength = mode 7
     REM T= mode 8= load tool offset
     REM mode 9 = null
     GOTO 3400: 'next letter

5300 REM                                                PARSE  X
     IF g90 = 1 THEN goX = g(3) * 10000 - bX: GOTO 3400
     IF g90 = 0 THEN goX = g(3) * 10000: GOTO 3400

5400 REM                                                PARSE  Y
     IF g90 = 1 THEN goY = g(4) * 10000 - bY: GOTO 3400
     IF g90 = 0 THEN goY = g(4) * 10000: GOTO 3400

5500 REM                                                PARSE  Z
     IF can = 1 THEN goZ = 0: GOTO 3400
     IF g90 = 1 THEN goZ = g(5) * 10000 - bZ: GOTO 3400
     IF g90 = 0 THEN goZ = g(5) * 10000: GOTO 3400

5600 REM                                                PARSE  I
     IF g90.1 = 0 THEN goI = g(6) * 10000: GOTO 3400
     IF g90.1 = 1 THEN goI = g(6) * 10000 - bX: GOTO 3400
     goI = ABS(goI)

5700 REM                                                PARSE  J
     IF g90.1 = 0 THEN goJ = g(7) * 10000: GOTO 3400
     IF g90.1 = 1 THEN goJ = g(7) * 10000 - bY: GOTO 3400
     goJ = ABS(goJ)

5800 REM                                                PARSE  K
     IF g90.1 = 0 THEN goK = g(8) * 10000: GOTO 3400
     IF g90.1 = 1 THEN goK = g(8) * 10000 - bZ: GOTO 3400
     goK = ABS(goK)

5900 REM                                                PARSE  F
5995 GOTO 3400

6000 REM                                                PARSE  M
     IF g(10) = 101 THEN HomeX = 1: homing = 1: GOTO 3400
     IF g(10) = 102 THEN HomeY = 1: homing = 1: GOTO 3400
     IF g(10) = 103 THEN HomeZ = 1: homing = 1: GOTO 3400
     IF g(10) = 0 THEN cycle = 0: p7 = rA: p8 = rB
     IF g(10) = 2 THEN cycle = 0: p7 = rA: p8 = rB: GOTO 150
     IF g(10) = 3 THEN p7 = 0: ' 0 for on, r? for off
     IF g(10) = 5 THEN p7 = rA
     IF g(10) = 6 THEN p7 = rA: p8 = rB: cycle = 0
     IF g(10) = 8 THEN p8 = 0
     IF g(10) = 9 THEN p8 = rB
     IF g(10) = 30 THEN p7 = rA: p8 = rB: cycle = 0: linecount = 1: GOTO 2310
     OUT port, 255 AND NOT p7 + p8
     
     GOTO 3400

6100 REM                                                 PARSE  S
     GOTO 3400

6200 REM                                                 PARSE  T
     tn1 = g(12)
     IF mode <> 7 THEN mode = 8: tn = g(12)
     GOTO 3400

6300 REM                                             PARSE \ -set tool length
     mode = 7
     GOTO 3400

6400 REM                                                  PARSE L
     g(14) = ABS(g(14))
     GOTO 3400

6425 REM                                                  Parse P
     g(15) = ABS(g(15))
     GOTO 3400

6450 REM                                                  parse U
     GOTO 3400

6475 REM                                                  Parse V
     GOTO 3400

6500 REM                                                  Parse W
     GOTO 3400
6550 REM                                                  Parse R
     GOTO 3400


6700 REM                                         backlash setup & execution

     IF goX < 0 THEN Xdir = -1 ELSE Xdir = 1
     IF goY < 0 THEN Ydir = -1 ELSE Ydir = 1
     IF goZ < 0 THEN Zdir = -1 ELSE Zdir = 1
     IF firstmove = 0 THEN firstmove = 1: GOTO 6790
     Xtemp = goX: Ytemp = goY: Ztemp = goZ: goX = 0: goY = 0: goZ = 0
     IF Xdir <> oldXdir THEN goX = Xb * Xdir: bkl = 1
     IF Ydir <> oldYdir THEN goY = Yb * Ydir: bkl = 1
     IF Zdir <> oldZdir THEN goZ = Zb * Zdir: bkl = 1
     IF bkl = 1 THEN GOSUB 7000
     bkl = 0: goX = Xtemp: goY = Ytemp: goZ = Ztemp
6790 GOSUB 7000
     RETURN: 'to parser or manual


7000 REM                                                LINEAR MOVE

     REM ON ERROR GOTO 150
     KEY(1) OFF: ON KEY(1) GOSUB 7901: ' hold
     ON KEY(2) GOSUB 7984: 'feed -
     ON KEY(3) GOSUB 7982: 'feed +
     KEY(1) ON: KEY(2) ON: KEY(3) ON
7100 Ad = INT(g(9)) * accd: Dd = INT(g(9)) * accd
     IF g(9) = 0 THEN
	g(9) = .1
	Frn = ABS(g(9))
	Fdr = Frn
	IF Fdr = 0 THEN Fdr = 1
     END IF
     go = 0
     IF bkl = 1 THEN Fdr = 100 ELSE Fdr = ABS(g(9))
     IF mode = 1 THEN Fdr = 100
     IF bkl = 1 OR mode = 1 THEN Ad = 100 * accd: Dd = 100 * accd
     Finv = Fdr * .01
     REM * OVR
     goX = ABS(goX): goY = ABS(goY): goZ = ABS(goZ):
     IF goX = 0 THEN stX = 0 ELSE stX = goX / mX
     IF goY = 0 THEN stY = 0 ELSE stY = goY / mY
     IF goZ = 0 THEN stZ = 0 ELSE stZ = goZ / mZ
     stX = ABS(stX): stY = ABS(stY): stZ = ABS(stZ)

7170 pt = 255 AND NOT p7 + p8: '                    preset direction pins
     IF Xdir = -1 THEN pt = pt AND NOT nX
     IF Ydir = -1 THEN pt = pt AND NOT nY
     IF Zdir = -1 THEN pt = pt AND NOT nZ
     OUT port, pt

7200 IF stX >= stY AND stX >= stZ THEN cts = stX: GOTO 7230
     IF stY >= stZ AND stY >= stX THEN cts = stY: GOTO 7230
     IF stZ >= stY AND stZ >= stY THEN cts = stZ: GOTO 7230
7230 REM
     IF goX = 0 THEN perX = 0 ELSE perX = goX / cts
     IF goY = 0 THEN perY = 0 ELSE perY = goY / cts
     IF goZ = 0 THEN perZ = 0 ELSE perZ = goZ / cts
     tX = 0: tY = 0: tZ = 0
     start = 1: cnt = 0: half = cts / 2: ct = 0
     IF hold = 1 THEN COLOR action: LOCATE 8, 28: PRINT "HOLD"
     COLOR axis
     LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000
     LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000
     LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000
     COLOR action
     LOCATE 8, 4: PRINT USING "###"; Fdr; : PRINT "      "
     IF Fdr = 100 AND bkl = 0 THEN
	LOCATE 8, 4: PRINT "RAPID   "
     END IF
     IF bkl = 1 THEN LOCATE 8, 4: PRINT "SLACK"
     ON KEY(6) GOSUB 150: KEY(6) ON
7260 IF panel = 0 THEN GOTO 7300

7265 GOSUB 20000: '                                       Panel
     IF button = 4 THEN hold = 1: GOSUB 7915: '   hold
     IF button = 1 THEN GOSUB 7984: ' ovr -
     IF button = 2 THEN GOSUB 7982: ' ovr +

7300 REM KEY(5) OFF:
     KEY(6) OFF
     ON KEY(6) GOSUB 7900: KEY(6) ON: 'hold & stop
     IF hold = 0 AND cycle = 1 THEN COLOR action: LOCATE 8, 28: PRINT "RUN    "

     IF hold = 1 THEN 7260

REM IF cycle = 0 THEN GOTO 7260
     IF goX < mX THEN goX = 0
     IF goY < mY THEN goY = 0
     IF goZ < mZ THEN goZ = 0

     OUT port2, 4
     hold = 0

REM     DO WHILE goX > tX OR goY > tY OR goZ > tZ: '      BEGIN MOVE LOOP

     FOR L1 = 0 TO cts

     IF tX >= goX THEN GOTO 7345: '                        X Axis
     Xe = cnt * perX - tX
     IF Xe < mX THEN GOTO 7345:
     'X= actual X, cX = machine X, bX = absolute X
     tX = tX + mX
     pt = pt AND NOT pX
     IF bkl = 0 THEN
      IF Xdir = -1 THEN bX = bX - mX: cX = cX - mX1:  ELSE bX = bX + mX: cX = cX + mX1
     END IF

7345  COLOR axis: LOCATE 2, 16: PRINT USING "######.####"; INT(bX) / 10000

     IF tY >= goY THEN GOTO 7400: '                        Y Axis
     Ye = cnt * perY - tY
     IF Ye < mY THEN GOTO 7400
     tY = tY + mY
     pt = pt AND NOT pY
     IF bkl = 0 THEN
       IF Ydir = -1 THEN bY = bY - mY: cY = cY - mY1:  ELSE bY = bY + mY: cY = cY + mY1
     END IF
7400 COLOR axis: LOCATE 4, 16: PRINT USING "######.####"; INT(bY) / 10000

     IF tZ >= goZ THEN GOTO 7485: '                        Z Axis
     Ze = cnt * perZ - tZ
     IF Ze < mZ THEN GOTO 7485
     tZ = tZ + mZ
     pt = pt AND NOT pZ
     IF bkl = 0 THEN
     IF Zdir = -1 THEN bZ = bZ - mZ: cZ = cZ - mZ1:  ELSE bZ = bZ + mZ: cZ = cZ + mZ1
     END IF
7485 COLOR axis: LOCATE 6, 16: PRINT USING "######.####"; INT(bZ) / 10000

     '                                                       Limit Switches
     IF INP(port2) = 236 THEN hold = 1: GOSUB 7915

7490 OUT port, pt
REM     LOCATE 8, 4: PRINT "      "
REM     LOCATE 8, 4
REM     IF mode = 2 THEN
REM      COLOR action: PRINT USING "###"; g(9)
REM      ELSE : COLOR action: PRINT "RAPID"
REM     END IF

     KEY(1) ON: KEY(2) ON: KEY(3) ON:


7500 REM                                                 acceleration loop
     IF go > Ad OR go > half THEN 7600
     IF hold = 1 THEN 7600
     FOR c = Ad - ct TO 1 STEP accf * -1

     NEXT c
     ct = ct + 1

7600 REM                                                   deceleration loop

     IF cnt < cts - Dd OR cnt < half THEN 7625

     IF hold = 1 THEN 7625
     FOR c = cnt - (cts - Dd) TO 1 STEP accf * -1
     REM cnt = current count; cts= total counts; Dd=decel distance
     REM accf = accel / decel factor, from setspeed

7615 NEXT c


7625 REM                                                    SLOW TO HOLD
     IF hold = 0 THEN 7670
     FOR h = htg TO hl STEP accf: NEXT h
     htg = htg - 1
7645 IF panel = 0 THEN 7665
     GOSUB 20000
     IF button = 3 THEN hold = 0
     IF button = 1 THEN GOSUB 7984
     IF button = 2 THEN GOSUB 7982
     IF rot > 1 AND rot < 6 AND htg < 0 THEN 150
7665 KEY(1) ON: KEY(2) ON: KEY(3) ON:
     IF htg < 0 AND hold = 1 THEN
	 IF homing = 1 THEN homing = 0: hold = 0: GOTO 7827
	 GOTO 7645
     END IF

7670 REM                                                    FEED
     FOR SLO = Fdr * FRF TO (compspeed / OVR + rpd) / Finv
     NEXT SLO
     REM

     KEY(1) STOP: KEY(2) STOP: KEY(3) STOP

7700 REM                                                    RESET PORT

     pt = 255 AND NOT p7 + p8: ' leave relays on
     IF Xdir = -1 THEN pt = pt AND NOT nX: ' leave direction pins on
     IF Ydir = -1 THEN pt = pt AND NOT nY
     IF Zdir = -1 THEN pt = pt AND NOT nZ
     OUT port, pt

7800 IF panel = 0 THEN GOTO 7825
     GOSUB 20000: '                                button
     IF button = 4 THEN hold = 1: GOSUB 7915: '   hold
     IF button = 1 THEN GOSUB 7984: ' ovr -
     IF button = 2 THEN GOSUB 7982: ' ovr +

7825 cnt = cnt + 1: go = go + 1

REM     LOOP: '                                       END MOVE LOOP

   NEXT L1

7827 REM                                          Clean up and Get Out
     IF bkl = 0 THEN
	IF goX < 0 THEN oldXdir = -1 ELSE oldXdir = 1
	IF goY < 0 THEN oldYdir = -1 ELSE oldYdir = 1
	IF goZ < 0 THEN oldZdir = -1 ELSE oldZdir = 1
     END IF


7895 RETURN: 'to backlash section or arc quadrant direction selection section


7900 cycle = 0: GOTO 150: '             stop is immediate and non recoverable
7901 REM
7905 IF hold = 1 THEN hold = 0 ELSE hold = 1: '                   hold
     IF hold = 0 THEN 7950
7915 IF H2 = 1 THEN hold = 0: RETURN
     IF cnt < cts - Dd THEN hl = Dd / 2: GOTO 7925
     hl = cts - cnt:

7925 htg = hl: COLOR action: LOCATE 8, 28: PRINT "HOLD   "
     IF cycle = 1 THEN RETURN
7945 RETURN

7950 REM                                                           unhold
     IF cnt < cts - (Ad + Dd) THEN reaccel = Ad: GOTO 7970
     reaccel = (cts - cnt) / 2
     half = cts + reaccel: go = 0: ct = 1
7970 COLOR action: LOCATE 8, 28: PRINT "RUN    "
     RETURN

7980 REM                                                    Feedrate overide
7982 OVR = OVR + .01: : GOTO 7985
7984 OVR = OVR - .01: IF OVR < .01 THEN OVR = .01
7985 IF OVR > 1 THEN OVR = 1
     
7995 COLOR action
     LOCATE 10, 4: PRINT USING "###"; OVR * 100; : PRINT "   "
     RETURN

8000 Ad = INT(g(9)) * accd: Dd = (g(9)) * accd: '              ARC SETUP
     Frn = ABS(g(9)): Fdr = Frn: FinvArc = ABS(g(9)) * .01:
     IF Fdr = 0 THEN Fdr = 1
     IF plane = 1 THEN
     goCos = goX: goSin = goY: goLin = goZ: CosOff = goI: SinOff = goJ
     CosM = mX: SinM = mY: LinM = mZ: CosM1 = mX1: SinM1 = mY1: LinM1 = mZ1
     CosDirPin = nX: SinDirPin = nY: LinDirPin = nZ
     CosStepPin = pX: SinStepPin = pY: LinStepPin = pZ
     CosLoc = 2: SinLoc = 4: LinLoc = 6
     oldCosDir = oldXdir: oldSinDir = oldYdir: oldLinDir = oldZdir
     END IF

     IF plane = 2 THEN
     goCos = goX: goSin = goZ: goLin = goY: CosOff = goI: SinOff = goK
     CosM = mX: SinM = mZ: LinM = mY: CosM1 = mX1: SinM1 = mZ1: LinM1 = mY1
     CosDirPin = nX: SinDirPin = nZ: LinDirPin = nY
     CosStepPin = pX: SinStepPin = pZ: LinStepPin = pY
     CosLoc = 2: SinLoc = 6: LinLoc = 4
     oldCosDir = oldXdir: oldSinDir = oldZdir: oldLinDir = oldYdir
     END IF

     IF plane = 3 THEN
     goCos = goY: goSin = goZ: goLin = goX: CosOff = goJ: SinOff = goK
     CosM = mY: SinM = mZ: LinM = mX: CosM1 = mY1: SinM1 = mZ1: LinM1 = mX1
     CosDirPin = nY: SinDirPin = nZ: LinDirPin = nX
     CosStepPin = pY: SinStepPin = pZ: LinStepPin = pX
     CosLoc = 4: SinLoc = 6: LinLoc = 2
     oldCosDir = oldYdir: oldSinDir = oldZdir: oldLinDir = oldXdir
     END IF

     REM                                          CALCULATE ARC ANGLES
     accel = 100: togo = 101: decel = 100: ct = 0: tohold = -1
     R1 = SQR(CosOff * CosOff + SinOff * SinOff)

     IF g90.1 <> 1 THEN GOTO 8060
     I1 = CosOff - goCos: J1 = SinOff - goSin: GOTO 8130:  '            g90.1

8060 REM new I & J routine uses SIGNED I and J
     I1 = goCos + CosOff * -1: J1 = goSin + SinOff * -1
     I1 = I1 * -1: J1 = J1 * -1

8130 IF CosOff = 0 THEN CosOff = .00001
     IF I1 = 0 THEN I1 = .00001
     stangle = ATN(SinOff / CosOff)
     endangle = ATN(J1 / I1)

     IF g(2) = 3 THEN
     IF CosOff >= 0 AND SinOff >= 0 THEN stangle = pi + stangle: 'OK 247,202
     IF CosOff >= 0 AND SinOff < 0 THEN stangle = pi + stangle: '158,112
     IF CosOff < 0 AND SinOff < 0 THEN stangle = stangle + 0: 'OK 68,
     IF CosOff < 0 AND SinOff >= 0 THEN stangle = stangle + pi * 2: 'OK 338

     IF I1 < 0 AND J1 >= 0 THEN endangle = endangle + pi * 2: 'OK 338,292
     IF I1 < 0 AND J1 < 0 THEN endangle = endangle + 0: 'OK 68,
     IF I1 >= 0 AND J1 < 0 THEN endangle = endangle + pi: 'OK 158,112
     IF I1 >= 0 AND J1 >= 0 THEN endangle = pi + endangle: 'OK 202 deg

     IF endangle <= stangle THEN endangle = endangle + pi * 2
	sweep = endangle - stangle
     END IF


     IF g(2) = 2 THEN
     REM                                                       >= needs checked
     IF CosOff >= 0 AND SinOff >= 0 THEN stangle = pi + stangle: 'OK 247,202
     IF CosOff >= 0 AND SinOff < 0 THEN stangle = pi + stangle: '158,112
     IF CosOff < 0 AND SinOff < 0 THEN stangle = stangle + 0: 'OK 68,
     IF CosOff < 0 AND SinOff >= 0 THEN stangle = stangle + pi * 2: 'OK 338

     IF I1 < 0 AND J1 >= 0 THEN endangle = endangle + pi * 2: 'OK 338,292
     IF I1 < 0 AND J1 < 0 THEN endangle = endangle + 0: 'OK 68,
     IF I1 >= 0 AND J1 < 0 THEN endangle = endangle + pi: 'OK 158,112
     IF I1 >= 0 AND J1 >= 0 THEN endangle = pi + endangle: 'OK 202 deg

     IF endangle >= stangle THEN stangle = stangle + pi * 2
     sweep = stangle - endangle
     END IF

     CosAct = COS(stangle) * R1
     SinAct = SIN(stangle) * R1
     IF ABS(CosAct) < .00001 THEN CosAct = 0
     IF ABS(SinAct) < .00001 THEN SinAct = 0
     Ang = stangle

     CosDelta = ATN(CosM / R1)
     SinDelta = ATN(SinM / R1)
     IF CosDelta >= SinDelta THEN Delta = SinDelta ELSE Delta = CosDelta
8345 cts = INT(sweep / Delta): togo = cts: LinReps = cts
     half = cts / 2: count = 0: go = 0

     IF goLin = 0 THEN LinSteps = 0 ELSE LinSteps = goLin / LinM: ' steps for Z axis move
     IF LinSteps > cts THEN Delta = Delta / 2: GOTO 8345
     REM  make sure  Z move can finish
     LinPer = ABS(goLin / LinReps): ' amount z axis must move per iteration
     LinAct = 0: '  actual pos (incremental) set to zero
     IF goLin < 0 THEN LinDir = -1 ELSE LinDir = 1
     goLin = ABS(goLin)

8400 KEY(1) OFF: KEY(2) OFF: KEY(3) OFF
     ON KEY(1) GOSUB 9905: ON KEY(2) GOSUB 9984: ON KEY(3) GOSUB 9982
     ON KEY(6) GOSUB 9900
     KEY(1) ON: KEY(2) ON: KEY(3) ON: KEY(6) ON
     COLOR action
     LOCATE 8, 4: PRINT USING "###"; g(9)
     LOCATE 10, 4: PRINT USING "###"; OVR * 100; : PRINT "   ";
     ON KEY(6) GOSUB 150: KEY(6) ON
8435 IF panel = 0 THEN 8500

8450 GOSUB 20000
     IF button = 4 THEN hold = 1: GOSUB 9915: '   hold        panel
     IF button = 1 THEN GOSUB 9984: ' ovr -
     IF button = 2 THEN GOSUB 9982: ' ovr +
     IF panel AND button = 3 THEN cycle = 1
     IF cycle = 0 THEN 8450

8500 IF g(2) = 3 THEN 8705: '                                   G2 Quadrants
     CosIs = 1: CosDir = -1: SinIs = -1: SinDir = -1: '4 ok
     GOSUB 8905
     IF Ang > pi * 3.5 AND Ang <= pi * 4 THEN backlash = 1: GOSUB 10000
8515 IF Ang < pi * 3.5 THEN 8530
     GOSUB 9000
     GOTO 8515

8530 CosIs = -1: CosDir = -1: SinIs = -1: SinDir = 1: '3 ok
     GOSUB 8905
     IF Ang > pi * 3 AND Ang <= pi * 3.5 THEN backlash = 1: GOSUB 10000
8540 IF Ang < pi * 3 THEN 8555
     GOSUB 9000
     GOTO 8540

8555 CosIs = -1: CosDir = 1: SinIs = 1: SinDir = 1: '2 ok
     GOSUB 8905
     IF Ang > pi * 2.5 AND Ang <= pi * 3 THEN backlash = 1: GOSUB 10000
8565 IF Ang < pi * 2.5 THEN 8580
     GOSUB 9000
     GOTO 8565

8580 CosIs = 1: CosDir = 1: SinIs = 1: SinDir = -1: '1 ok
8582 GOSUB 8905
     IF Ang > pi * 2 AND Ang <= pi * 2.5 THEN backlash = 1: GOSUB 10000
8590 IF Ang < pi * 2 THEN 8605
     GOSUB 9000
     GOTO 8590

8605 CosIs = 1: CosDir = -1: SinIs = -1: SinDir = -1: '4
     GOSUB 8905
     IF Ang > pi * 1.5 AND Ang <= pi * 2 THEN bkl = 1: GOSUB 10000
8615 IF Ang < pi * 1.5 THEN 8630
     GOSUB 9000
     GOTO 8615

8630 CosIs = -1: CosDir = -1: SinIs = -1: SinDir = 1
     GOSUB 8905
     IF Ang > pi * 1 AND Ang <= pi * 1.5 THEN bkl = 1: GOSUB 10000
8640 IF Ang < pi * 1 THEN 8655
     GOSUB 9000
     GOTO 8640

8655 CosIs = -1: CosDir = 1: SinIs = 1: SinDir = 1
     GOSUB 8905
     IF Ang > pi * .5 AND Ang <= pi * 1 THEN bkl = 1: GOSUB 10000
8665 IF Ang < pi * .5 THEN 8680
     GOSUB 9000
     GOTO 8665

8680 CosIs = 1: CosDir = 1: SinIs = 1: SinDir = -1
     GOSUB 8905
     IF Ang > 0 AND Ang <= pi * .5 THEN bkl = 1: GOSUB 10000
8690 IF Ang < 0 THEN RETURN: 'to parser
     GOSUB 9000
     GOTO 8690

8705 CosIs = 1: CosDir = -1: : SinIs = 1: SinDir = 1: '1 OK     G3 Quadrants
     GOSUB 8905
     IF Ang >= 0 AND Ang <= pi * .5 THEN bkl = 1: GOSUB 10000
8715 IF Ang > pi * .5 THEN 8730
     GOSUB 9000
     GOTO 8715

8730 CosIs = -1: CosDir = -1: SinIs = 1: SinDir = -1: ' 2 OK
     GOSUB 8905
     IF Ang > pi * .5 AND Ang <= pi * 1 THEN bkl = 1: GOSUB 10000
8740 IF Ang > pi * 1 THEN 8755
     GOSUB 9000
     GOTO 8740

8755 CosIs = -1: CosDir = 1: SinIs = -1: SinDir = -1: ' 3 OK
     GOSUB 8905
     IF Ang > pi * 1 AND Ang <= pi * 1.5 THEN bkl = 1: GOSUB 10000
8765 IF Ang > pi * 1.5 THEN 8780
     GOSUB 9000
     GOTO 8765

8780 CosIs = 1: CosDir = 1: SinIs = -1: SinDir = 1: '4 OK
     GOSUB 8905
     IF Ang > pi * 1.5 AND Ang <= pi * 2 THEN bkl = 1: GOSUB 10000
8790 IF Ang > pi * 2 THEN 8805
     GOSUB 9000
     GOTO 8790

8805 CosIs = 1: CosDir = -1: SinIs = 1: SinDir = 1
     GOSUB 8905
     IF Ang > pi * 2 AND Ang <= pi * 2.5 THEN bkl = 1: GOSUB 10000
8815 IF Ang > pi * 2.5 THEN 8830
     GOSUB 9000
     GOTO 8815

8830 CosIs = -1: CosDir = -1: SinIs = 1: SinDir = -1
     GOSUB 8905
     IF Ang > pi * 2.5 AND Ang <= pi * 3 THEN bkl = 1: GOSUB 10000
8840 IF Ang > pi * 3 THEN 8855
     GOSUB 9000
     GOTO 8840

8855 CosIs = -1: CosDir = 1: SinIs = -1: SinDir = -1
     GOSUB 8905
     IF Ang > pi * 3 AND Ang <= pi * 3.5 THEN bkl = 1: GOSUB 10000
8865 IF Ang > pi * 3.5 THEN 8880
     GOSUB 9000
     GOTO 8865

8880 CosIs = 1: CosDir = 1: SinIs = -1: SinDir = 1
     GOSUB 8905
     IF Ang > pi * 3.5 AND Ang <= pi * 4 THEN bkl = 1: GOSUB 10000
8890 IF Ang > pi * 4 THEN RETURN: 'to parser
     GOSUB 9000
     GOTO 8890

8905 REM                                      preset direction pins
     pt = 255 OR p7 + p8
     IF CosDir = -1 THEN pt = pt AND NOT CosPinDir
     IF SinDir = -1 THEN pt = pt AND NOT SinPinDir
     IF LinDir = -1 THEN pt = pt AND NOT LinPinDir
     OUT port, pt
     RETURN

9000 IF panel = 0 THEN 9100
     GOSUB 20000
     IF button = 4 THEN hold = 1: GOSUB 9915: '   hold        panel
     IF button = 1 THEN GOSUB 9984: ' ovr -
     IF button = 2 THEN GOSUB 9982: ' ovr +


9100 KEY(1) STOP: KEY(2) STOP: KEY(3) STOP
     xCos = ABS(COS(Ang)) * R1 * CosIs: '               COSINE AXIS (x)
     CosErr = ABS(xCos - CosAct) + .45 * CosM
     IF CosErr < CosM THEN CosDsp = 0: GOTO 9200
     CosAct = CosAct + (CosM * CosDir): pt = pt AND NOT CosStepPin
     IF CosDir = -1 THEN CosDsp = -1 ELSE CosDsp = 1

9200 xSin = ABS(SIN(Ang)) * R1 * SinIs: '                Sine Axis (y)                                       '                   SINE AXIS
     SinErr = ABS(xSin - SinAct) + .45 * SinM
     IF SinErr < SinM THEN SinDsp = 0: GOTO 9260
     SinAct = SinAct + (SinM * SinDir): pt = pt AND NOT SinStepPin
     IF SinDir = -1 THEN SinDsp = -1 ELSE SinDsp = 1

9260 IF LinAct > goLin THEN GOTO 9300: '                     LINEAR AXIS
     LinErr = count * LinPer - LinAct
     IF LinErr + .45 < LinM THEN GOTO 9300
     LinAct = LinAct + LinM: pt = pt AND NOT LinStepPin
     IF LinDir = -1 THEN LinDsp = -1 ELSE LinDsp = 1

9300 OUT port, pt
     GOSUB 10500: '            display and position registers
     count = count + 1: CosDsp = 0: SinDsp = 0: LinDsp = 0
     togo = togo - 1

     KEY(1) ON: KEY(2) ON: KEY(3) ON:


9320 IF go > Ad THEN 9360:  '                                    ACCEL
     IF go > half THEN 9360
     IF hold = 1 THEN 9400
     FOR c = Ad - ct TO 1 STEP accf * -1
     NEXT c

9360 IF togo > Dd THEN 9400: '                                  DECEL
     IF togo > half THEN 9400
     IF hold = 1 THEN 9400
     FOR c = 0 TO Dd - togo STEP accf
     NEXT c

9400 IF hold = 0 THEN 9410: '                                 SLOW TO HOLD
     FOR h = htg TO hl STEP 1: NEXT h
     htg = htg - 1
     IF panel = 0 THEN 9405
     GOSUB 20000
     IF button = 3 THEN hold = 0
     IF button = 1 THEN GOSUB 7984
     IF button = 2 THEN GOSUB 7982
     IF rot > 1 AND rot < 6 AND htg < 0 THEN 150
9405 KEY(1) ON: KEY(2) ON: KEY(3) ON: IF htg < 0 AND hold = 1 THEN GOTO 9405



9410  IF INP(port2) = 236 THEN hold = 1: GOSUB 9915
     

9416 IF panel = 0 THEN 9440
     GOSUB 20000
     IF button = 3 THEN hold = 0: GOSUB 9950: '  unhold        panel
     IF button = 1 THEN GOSUB 9984: ' ovr -
     IF button = 2 THEN GOSUB 9982: ' ovr +
9440 IF htg < 0 AND hold = 1 THEN 9416

9450 REM                                                         FEED
     FOR SLO = Fdr * FRF TO (compspeed / OVR + rpd) / FinvArc
     NEXT SLO


9700 REM                                                    RESET PORT
     pt = 255 AND NOT p7 + p8
     IF CosDir = -1 THEN pt = pt AND NOT CosDirPin: ' leave direction pins on
     IF SinDir = -1 THEN pt = pt AND NOT SinDirPin
     IF LinDir = -1 THEN pt = pt AND NOT LinDirPin
     OUT port, pt
     go = go + 1: LinReps = LinReps + .5

     IF g(2) = 3 THEN
     Ang = Ang + Delta: '                   increment Angle & check for end
	IF Ang > endangle THEN
	   Ang = pi * 6
	   oldSinDir = SinDir: oldCosDir = CosDir: oldLinDir = LinDir
	   RETURN
	END IF
     END IF

     IF g(2) = 2 THEN
     Ang = Ang - Delta
	 IF Ang < endangle THEN
	 Ang = pi * -1
	 oldSinDir = SinDir: oldCosDir = CosDir: oldLinDir = LinDir
	 RETURN
	 END IF
     END IF

9875 RETURN

9880 STOP: KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(6) OFF
9885 CosAbs = INT(CosAbs)
9890 SinAbs = INT(SinAbs)
9895 RETURN

9900 cycle = 0: GOTO 150: '                             HOLD
9905 IF hold = 1 THEN hold = 0 ELSE hold = 1
     IF hold = 0 THEN 9950
9915 IF ct < cts - Dd THEN hl = Dd / 2 ELSE hl = cts - cnt
     htg = hl: COLOR action: LOCATE 8, 28: PRINT "HOLD"
     IF cycle = 1 THEN RETURN

9935 RETURN

9950 REM                                                          UNHOLD
     IF togo < cts - (Ad + Dd) THEN reaccel = Ad: GOTO 9970
     reaccel = (cts - togo) / 2
9970 half = cts + reaccel: go = 0: ct = 1
     COLOR action: LOCATE 8, 28: PRINT "RUN     "
     RETURN

9980 REM                                                    Feedrate overide
9982 OVR = OVR + .01: : GOTO 9985
9984 OVR = OVR - .01: IF OVR < 0 THEN OVR = 0
9985 IF OVR > 1 THEN OVR = 1
     Fdr = Frn * OVR: COLOR action
     LOCATE 10, 4: PRINT USING "###"; OVR * 100; : PRINT "   ": RETURN

10000 REM                                            Backlash for Arc
      goX = 0: goY = 0: goZ = 0
      ON plane GOTO 10100, 10200, 10300
10100 IF CosDir <> oldCosDir THEN goX = Xb * CosDir: bkl = 1: '  G17 backlash
      IF SinDir <> oldSinDir THEN goY = Yb * SinDir: bkl = 1
      IF LinDir <> oldLinDir THEN goZ = Zb * LinDir: bkl = 1
      IF bkl = 1 THEN GOSUB 7100
      Frn = ABS(g(9)): Fdr = Frn * OVR: go = 0
      COLOR action: LOCATE 8, 4: PRINT USING "###"; g(9); : PRINT "    "
      bkl = 0: RETURN: ' to quadrant direction selection section

10200 IF CosDir <> oldCosDir THEN goX = Xb * CosDir: bkl = 1: '  G18  backlash
      IF SinDir <> oldSinDir THEN goZ = Zb * SinDir: bkl = 1
      IF LinDir <> oldLinDir THEN goZ = Yb * LinDir: bkl = 1
      IF bkl = 1 THEN GOSUB 7100
      Frn = ABS(g(9)): Fdr = Fdn * OVR: go = 0
      COLOR action: LOCATE 8, 4: PRINT USING "###"; g(9); : PRINT "   "
      bkl = 0: RETURN: ' to quadrant direction selection section

10300 IF CosDir <> oldCosDir THEN goY = Yb * CosDir: bkl = 1: '  G19  backlash
      IF SinDir <> oldSinDir THEN goZ = Zb * SinDir: bkl = 1
      IF LinDir <> oldLinDir THEN goX = Xb * LinDir: bkl = 1
      IF bkl = 1 THEN GOSUB 7100
      Frn = ABS(g(9)): Fdr = Fdn * OVR: go = 0
      COLOR action: LOCATE 8, 4: PRINT USING "###"; g(9); : PRINT "    "
      bkl = 0: RETURN: ' to quadrant direction selection section


10500 REM                                            Display & position
      ON plane GOTO 10600, 10700, 10800
10600 bX = bX + CosDsp * mX: bY = bY + SinDsp * mY: bZ = bZ + LinDsp * mZ
      cX = cX + CosDsp * mX1: cY = cY + SinDsp * mY1: cZ = cZ + LinDsp * mZ1
      GOTO 10900
10700 bX = bX + CosDsp * mX: bZ = bZ + SinDsp * mZ: bY = bY + LinDsp * mY
      cX = cX + CosDsp * mX1: cZ = cZ + SinDsp * mZ1: cY = cY + LinDsp * mY1
      GOTO 10900
10800 bY = bY + CosDsp * mY: bZ = bZ + SinDsp * mZ: bX = bX + LinDsp * mX
      cY = cY + CosDsp * mY1: cZ = cZ + SinDsp * mZ1: cX = cX + LinDsp * mY1
      GOTO 10900

10900 REM display
      COLOR axis
      LOCATE 2, 16: PRINT USING "######.####"; (INT(bX)) / 10000
      LOCATE 4, 16: PRINT USING "######.####"; (INT(bY)) / 10000
      LOCATE 6, 16: PRINT USING "######.####"; (INT(bZ)) / 10000
 
      RETURN


20000 REM                                        Read Panel
      REM read rotary
      rot = 0
      IF NOT INP(port1) AND 64 THEN rot = 1: ' pin 10
      IF INP(port1) AND 128 THEN rot = rot + 2: ' pin 11
      IF NOT INP(port1) AND 32 THEN rot = rot + 4: ' pin 12

20100 REM read buttons
      button = 0
      IF INP(port2) AND 1 THEN button = 1: 'ovr -, pin 1
      IF INP(port2) AND 2 THEN button = 2: 'ovr +, pin 14
      IF NOT INP(port2) AND 4 THEN button = 3: 'start, pin 16
      IF INP(port2) AND 8 THEN button = 4: 'Hold, pin 17

      RETURN

